<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/functions.php';

$err = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['username'] ?? '';
    $pass = $_POST['password'] ?? '';
  if (attempt_login($user, $pass)) {
    header('Location: dashboard.php');
        exit;
    } else {
        $err = 'Login gagal - cek username/password';
    }
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login</title>
  <!-- AdminLTE + dependencies (local AdminLTE css) -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/vendor/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/vendor/bootstrap5/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/dist/css/adminlte.min.css">
</head>
<body class="hold-transition login-page">
  <div class="login-box">
    <div class="card card-outline card-primary">
      <div class="card-header text-center">
        <a href="#" class="h1"><b>Admin</b>LTE</a>
      </div>
      <div class="card-body">
        <p class="login-box-msg">Masuk untuk memulai sesi admin</p>
        <?php if ($err): ?>
          <div class="alert alert-danger"><?php echo e($err); ?></div>
        <?php endif; ?>
        <form method="post">
          <div class="input-group mb-3">
            <input name="username" class="form-control" placeholder="Username">
            <div class="input-group-append input-group-text"><span class="fas fa-user"></span></div>
          </div>
          <div class="input-group mb-3">
            <input name="password" type="password" class="form-control" placeholder="Password">
            <div class="input-group-append input-group-text"><span class="fas fa-lock"></span></div>
          </div>
          <div class="row">
            <div class="col-8"></div>
            <div class="col-4"><button class="btn btn-primary btn-block">Masuk</button></div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <script src="<?php echo base_url(); ?>/assets/vendor/bootstrap5/js/bootstrap.bundle.min.js"></script>
  <script src="<?php echo base_url(); ?>/assets/dist/js/adminlte.min.js"></script>
</body>
</html>