<?php
// admin/visimisi.php - CRUD Visi Misi
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$db = get_db();
// Table for visi misi (single row)
$db->exec("CREATE TABLE IF NOT EXISTS visimisi (
    id INTEGER PRIMARY KEY CHECK (id = 1),
    visi TEXT,
    misi TEXT
)");
// Fetch or create default
$row = $db->query("SELECT * FROM visimisi WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    $db->exec("INSERT INTO visimisi (id, visi, misi) VALUES (1, '', '')");
    $row = ['visi'=>'', 'misi'=>''];
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $visi = trim($_POST['visi'] ?? '');
    $misi = trim($_POST['misi'] ?? '');
    $stmt = $db->prepare("UPDATE visimisi SET visi=?, misi=? WHERE id=1");
    $stmt->execute([$visi, $misi]);
    header('Location: visimisi.php?msg=saved'); exit;
}
include '_header.php';
?>
<div class="container-fluid">
  <h1 class="mt-3 mb-4">Visi & Misi Sekolah</h1>
  <?php if (!empty($_GET['msg'])): ?><div class="alert alert-success">Data berhasil disimpan.</div><?php endif; ?>
  <form method="post" class="card p-3 mb-4">
    <div class="mb-3">
      <label class="form-label">Visi</label>
      <textarea name="visi" class="form-control tinymce" rows="3" required><?php echo e($row['visi']); ?></textarea>
    </div>
    <div class="mb-3">
      <label class="form-label">Misi</label>
      <textarea name="misi" class="form-control tinymce" rows="5" required><?php echo e($row['misi']); ?></textarea>
    </div>
    <button type="submit" class="btn btn-primary">Simpan</button>
  </form>
  <script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
  <script>
tinymce.init({ selector: 'textarea.tinymce', height: 220, menubar: false, plugins: 'lists link', toolbar: 'undo redo | bold italic underline | bullist numlist | link', branding: false });
</script>
</div>
<?php include '_footer.php'; ?>
