<?php
/**
 * Database Configuration Template
 * 
 * Copy this file to config/database.php and update with your actual credentials.
 * IMPORTANT: Never commit config/database.php to version control!
 */

// ============================================================================
// DATABASE TYPE SELECTION
// ============================================================================
// Options: 'mysql' or 'sqlite'
// Use 'mysql' for production environments with multiple concurrent users
// Use 'sqlite' for development or small single-user deployments
define('DB_TYPE', 'sqlite');

// ============================================================================
// MYSQL CONFIGURATION
// ============================================================================
// These settings are used when DB_TYPE = 'mysql'

// MySQL Server Host (usually 'localhost' or '127.0.0.1')
define('DB_HOST', 'localhost');

// MySQL Database Name
define('DB_NAME', 'mygb_school');

// MySQL Username
define('DB_USER', 'root');

// MySQL Password
define('DB_PASS', '');

// MySQL Port (default: 3306)
define('DB_PORT', 3306);

// Character Set (recommended: utf8mb4 for full Unicode support including emoji)
define('DB_CHARSET', 'utf8mb4');

// Collation (recommended: utf8mb4_unicode_ci for proper sorting)
define('DB_COLLATION', 'utf8mb4_unicode_ci');

// ============================================================================
// SQLITE CONFIGURATION
// ============================================================================
// These settings are used when DB_TYPE = 'sqlite'

// Path to SQLite database file (relative to this config file)
define('SQLITE_DB_PATH', __DIR__ . '/../data/school.db');

// ============================================================================
// ADVANCED SETTINGS (Optional)
// ============================================================================

// Enable query logging for debugging (not recommended for production)
define('DB_DEBUG', false);

// Connection timeout in seconds
define('DB_TIMEOUT', 30);

// ============================================================================
// NOTES
// ============================================================================
// 
// MySQL Setup Instructions:
// 1. Install MySQL/MariaDB server (included in XAMPP)
// 2. Start MySQL service
// 3. Create database: CREATE DATABASE mygb_school CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
// 4. Create user (optional): CREATE USER 'mygb_user'@'localhost' IDENTIFIED BY 'your_password';
// 5. Grant permissions: GRANT ALL PRIVILEGES ON mygb_school.* TO 'mygb_user'@'localhost';
// 6. Update DB_USER and DB_PASS above with your credentials
// 7. Change DB_TYPE to 'mysql'
//
// SQLite Setup Instructions:
// 1. Ensure data/ directory exists and is writable
// 2. Run init_db.php to create the database
// 3. Keep DB_TYPE as 'sqlite'
//
// Migration from SQLite to MySQL:
// 1. Configure MySQL settings above
// 2. Run migrate_to_mysql.php script
// 3. Verify data integrity
// 4. Change DB_TYPE to 'mysql'
// 5. Test application thoroughly
//
// Security Recommendations:
// - Use strong passwords for MySQL users
// - Restrict MySQL user permissions to only necessary operations
// - Keep config/database.php outside web root if possible
// - Ensure .htaccess protects config directory
// - Never commit config/database.php to version control
//
