<?php
// public/berita.php - List Berita (News) for frontend
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$db = get_db();
$berita = $db->query("SELECT * FROM berita ORDER BY date DESC, id DESC")->fetchAll(PDO::FETCH_ASSOC);

include '_header.php';
?>
<div class="container py-4">
  <h1 class="mb-4">Berita</h1>
  <div class="row">
    <?php foreach ($berita as $b): ?>
      <div class="col-md-6 col-lg-4 mb-4">
        <div class="card h-100">
          <?php if ($b['image']): ?>
            <img src="../data/uploads/<?php echo e($b['image']); ?>" class="card-img-top" alt="Gambar Berita" style="object-fit:cover;max-height:180px;">
          <?php endif; ?>
          <div class="card-body">
            <h5 class="card-title"><a href="berita_detail.php?id=<?php echo $b['id']; ?>"><?php echo e($b['title']); ?></a></h5>
            <div class="mb-1"><span class="badge bg-info text-dark">Kategori: <?php echo e($b['kategori'] ?? '-'); ?></span></div>
            <div class="text-muted mb-2" style="font-size:0.95em;">Diposting <?php echo e($b['date']); ?> oleh <?php echo e($b['author']); ?></div>
            <div class="card-text mb-2" style="min-height:60px;max-height:70px;overflow:hidden;">
              <?php echo nl2br(e(mb_substr(strip_tags($b['content']),0,120))) . (mb_strlen(strip_tags($b['content']))>120?'...':''); ?>
            </div>
            <a href="berita_detail.php?id=<?php echo $b['id']; ?>" class="btn btn-outline-primary btn-sm">Baca Selengkapnya</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include '_footer.php'; ?>
