<?php
// public/download.php - List Downloadable Files for frontend
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$db = get_db();
$downloads = $db->query("SELECT * FROM download ORDER BY date DESC, id DESC")->fetchAll(PDO::FETCH_ASSOC);

include '_header.php';
?>
<div class="container py-4">
  <h1 class="mb-4">Download</h1>
  <div class="row">
    <?php foreach ($downloads as $d): ?>
      <div class="col-md-6 col-lg-4 mb-4">
        <div class="card h-100">
          <div class="card-body">
            <h5 class="card-title"><?php echo e($d['title']); ?></h5>
            <div class="mb-1"><span class="badge bg-info text-dark">Kategori: <?php echo e($d['kategori'] ?? '-'); ?></span></div>
            <div class="text-muted mb-2" style="font-size:0.95em;">Tanggal: <?php echo e($d['date']); ?></div>
            <div class="mb-2" style="min-height:40px;max-height:60px;overflow:hidden;">
              <?php echo nl2br(e(mb_substr(strip_tags($d['description']),0,120))) . (mb_strlen(strip_tags($d['description']))>120?'...':''); ?>
            </div>
            <?php if ($d['file']): ?>
              <a href="../data/uploads/<?php echo e($d['file']); ?>" class="btn btn-outline-primary btn-sm" target="_blank"><i class="fa fa-download"></i> Download</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include '_footer.php'; ?>
