<?php
// public/index.php - Homepage
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/db.php';
$db = get_db();

// Load active slides
$slides = [];
try {
  $slides = $db->query('SELECT * FROM slides WHERE active = 1 ORDER BY display_order ASC')->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $slides = []; }

// Load latest berita
$berita = [];
try {
  $berita = $db->query('SELECT * FROM berita ORDER BY date DESC LIMIT 3')->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $berita = []; }

require __DIR__ . '/_header.php';
?>

<!-- Full Page Hero Slider -->
<section class="hero-slider-fullpage">
 
    <div class="row g-4 align-items-center">
      <div class="col-lg-6">
        <div class="hero-content">
        <h1 class="display-4 fw-bold">Selamat Datang di<br><?php echo e(get_setting('site_name','Sekolah Kita')); ?></h1>
        <p class="lead mt-3"><?php echo e(get_setting('site_description', 'Situs resmi sekolah — pengumuman, profil, dan informasi penting. Temukan kegiatan terbaru di sini.')); ?></p>
        <div class="mt-4 mb-2">
          <a class="btn btn-primary btn-lg me-3 mb-2" href="<?php echo base_url(); ?>/public/students.php">
            <i class="fa fa-users me-2"></i>Lihat Daftar Siswa
          </a>
          <a class="btn btn-outline-light btn-lg mb-2" href="<?php echo base_url(); ?>/public/about.php">
            <i class="fa fa-info-circle me-2"></i>Tentang Kami
          </a>
        </div>
        <?php if ($address = get_setting('site_address')): ?>
          <p class="text-white-50 small mt-3 mb-0">
            <i class="fa fa-map-marker-alt me-1"></i> <?php echo e($address); ?>
          </p>
        <?php endif; ?>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="hero-media">
        <?php if (count($slides) > 0): ?>
          <div id="heroCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
              <?php foreach ($slides as $i => $sl): ?>
                <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="<?php echo $i; ?>" 
                        class="<?php echo $i===0 ? 'active' : ''; ?>" 
                        aria-current="<?php echo $i===0 ? 'true' : 'false'; ?>" 
                        aria-label="Slide <?php echo $i+1; ?>"></button>
              <?php endforeach; ?>
            </div>
            <div class="carousel-inner" style="border-radius: 1rem; overflow: hidden;">
              <?php foreach ($slides as $i => $sl): ?>
                <?php $img = !empty($sl['image']) ? base_url() . '/data/uploads/slides/' . $sl['image'] : base_url() . '/assets/dist/assets/img/photo4.jpg'; ?>
                <div class="carousel-item <?php echo $i === 0 ? 'active' : ''; ?>">
                  <div class="card shadow-lg overflow-hidden border-0" style="border-radius: 1rem;">
                    <img src="<?php echo $img; ?>" class="card-img-top" alt="<?php echo e($sl['title'] ?? 'Slide'); ?>" style="height: 450px; object-fit: cover; border-radius: 1rem;">
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev" style="width: 40px; height: 40px; background: rgba(255,255,255,0.9); border-radius: 50%; left: 10px; top: 50%; transform: translateY(-50%);">
              <span class="carousel-control-prev-icon" aria-hidden="true" style="filter: invert(1); width: 20px; height: 20px;"></span>
              <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next" style="width: 40px; height: 40px; background: rgba(255,255,255,0.9); border-radius: 50%; right: 10px; top: 50%; transform: translateY(-50%);">
              <span class="carousel-control-next-icon" aria-hidden="true" style="filter: invert(1); width: 20px; height: 20px;"></span>
              <span class="visually-hidden">Next</span>
            </button>
          </div>
        <?php else: ?>
          <div class="card shadow-lg border-0 overflow-hidden" style="border-radius: 1rem;">
            <img src="<?php echo base_url(); ?>/assets/dist/assets/img/photo4.jpg" class="card-img-top" style="height: 450px; object-fit: cover; border-radius: 1rem;" alt="Sekolah">
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>


<!-- About Section -->
<section class="py-5 bg-white" style="margin-top: 0;">
  <div class="container py-4">
    <div class="row align-items-center g-5">
      <div class="col-lg-6">
        <div class="pe-lg-4">
          <span class="badge bg-primary-subtle text-primary mb-3">Tentang Kami</span>
          <h2 class="display-5 fw-bold mb-4">Membangun Generasi Unggul dan Berkarakter</h2>
          <p class="text-muted mb-4 lead">Kami berkomitmen untuk mendukung pendidikan yang berkualitas dan memberikan peluang bagi setiap siswa untuk berkembang.</p>
          <p class="text-muted mb-4">Sekolah kita fokus pada pembelajaran modern, pembentukan karakter yang kuat, dan pengembangan keterampilan abad ke-21 yang dibutuhkan untuk masa depan.</p>
          <a href="<?php echo base_url(); ?>/public/about.php" class="btn btn-primary btn-lg">
            <i class="fa fa-arrow-right me-2"></i>Selengkapnya
          </a>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="row g-4">
          <div class="col-sm-6">
            <div class="feature-card text-center h-100 p-4">
              <div class="feature-icon mb-3">
                <i class="fa fa-book fa-3x text-primary"></i>
              </div>
              <h5 class="mb-3">Kurikulum Modern</h5>
              <p class="text-muted small mb-0">Pembelajaran terpadu dengan pendekatan praktis dan pembentukan karakter</p>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="feature-card text-center h-100 p-4">
              <div class="feature-icon mb-3">
                <i class="fa fa-building fa-3x text-primary"></i>
              </div>
              <h5 class="mb-3">Fasilitas Lengkap</h5>
              <p class="text-muted small mb-0">Laboratorium, perpustakaan, dan ruang kreatif untuk mendukung pembelajaran</p>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="feature-card text-center h-100 p-4">
              <div class="feature-icon mb-3">
                <i class="fa fa-briefcase fa-3x text-primary"></i>
              </div>
              <h5 class="mb-3">Bimbingan Karir</h5>
              <p class="text-muted small mb-0">Mempersiapkan siswa untuk pendidikan tinggi dan karir masa depan</p>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="feature-card text-center h-100 p-4">
              <div class="feature-icon mb-3">
                <i class="fa fa-users fa-3x text-primary"></i>
              </div>
              <h5 class="mb-3">Komunitas Aktif</h5>
              <p class="text-muted small mb-0">Kegiatan ekstrakurikuler yang mendukung pengembangan minat dan bakat</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Berita Terbaru -->
<?php if (!empty($berita)): ?>
<section class="py-5 bg-light">
  <div class="container py-4">
    <div class="row mb-5">
      <div class="col-lg-8 mx-auto text-center">
        <span class="badge bg-primary-subtle text-primary mb-3">Berita & Informasi</span>
        <h2 class="display-5 fw-bold mb-3">Berita Terbaru</h2>
        <p class="text-muted lead">Ikuti perkembangan dan kegiatan terbaru di sekolah kami</p>
      </div>
    </div>
    <div class="row g-4 mb-4">
      <?php foreach ($berita as $b): ?>
        <div class="col-lg-4 col-md-6">
          <div class="card h-100 border-0 shadow-sm">
            <div class="position-relative overflow-hidden">
              <?php if (!empty($b['image'])): ?>
                <img src="<?php echo base_url(); ?>/data/uploads/berita/<?php echo e($b['image']); ?>" 
                     class="card-img-top" alt="<?php echo e($b['title']); ?>" style="height: 240px; object-fit: cover;">
              <?php else: ?>
                <div class="card-img-top bg-gradient d-flex align-items-center justify-content-center" style="height: 240px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                  <i class="fa fa-newspaper fa-4x text-white opacity-50"></i>
                </div>
              <?php endif; ?>
              <div class="position-absolute top-0 start-0 m-3">
                <span class="badge bg-primary"><?php echo e($b['kategori'] ?? 'Umum'); ?></span>
              </div>
            </div>
            <div class="card-body d-flex flex-column">
              <div class="mb-3">
                <small class="text-muted">
                  <i class="fa fa-calendar me-1"></i><?php echo date('d M Y', strtotime($b['date'])); ?>
                </small>
              </div>
              <h5 class="card-title mb-3"><?php echo e($b['title']); ?></h5>
              <p class="card-text text-muted flex-grow-1">
                <?php echo e(mb_substr(strip_tags($b['content']), 0, 120)); ?>...
              </p>
              <a href="<?php echo base_url(); ?>/public/berita_detail.php?id=<?php echo $b['id']; ?>" 
                 class="btn btn-outline-primary w-100 mt-3">
                Baca Selengkapnya <i class="fa fa-arrow-right ms-2"></i>
              </a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <div class="text-center">
      <a href="<?php echo base_url(); ?>/public/berita.php" class="btn btn-primary btn-lg">
        Lihat Semua Berita <i class="fa fa-arrow-right ms-2"></i>
      </a>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="cta-section text-center text-white">
  <div class="container">
    <h3 class="fw-bold mb-3">Bergabunglah Bersama Kami</h3>
    <p class="mb-4 lead">Dukung proses pendidikan dan jadikan sekolah kita tempat tumbuh yang aman dan inspiratif.</p>
    <div class="d-flex gap-3 justify-content-center flex-wrap">
      <a href="<?php echo base_url(); ?>/public/students.php" class="btn btn-light btn-lg">
        <i class="fa fa-user-plus me-2"></i>Daftar Sekarang
      </a>
      <a href="<?php echo base_url(); ?>/public/kontak.php" class="btn btn-outline-light btn-lg">
        <i class="fa fa-envelope me-2"></i>Hubungi Kami
      </a>
    </div>
  </div>
</section>

<!-- Quick Links -->
<section class="py-5 bg-white">
  <div class="container py-4">
    <div class="row mb-5">
      <div class="col-lg-8 mx-auto text-center">
        <span class="badge bg-primary-subtle text-primary mb-3">Akses Cepat</span>
        <h2 class="display-5 fw-bold mb-3">Layanan & Informasi</h2>
        <p class="text-muted lead">Temukan informasi yang Anda butuhkan dengan mudah</p>
      </div>
    </div>
    <div class="row g-4">
      <div class="col-lg-3 col-md-6">
        <a href="<?php echo base_url(); ?>/public/berita.php" class="text-decoration-none">
          <div class="card border-0 shadow-sm h-100 text-center hover-lift">
            <div class="card-body p-4">
              <div class="icon-box mb-4">
                <div class="icon-circle bg-primary-subtle">
                  <i class="fa fa-bullhorn fa-2x text-primary"></i>
                </div>
              </div>
              <h5 class="card-title mb-3">Pengumuman</h5>
              <p class="card-text text-muted small mb-0">Cek pengumuman terbaru mengenai jadwal dan kegiatan sekolah</p>
            </div>
          </div>
        </a>
      </div>
      <div class="col-lg-3 col-md-6">
        <a href="<?php echo base_url(); ?>/public/kurikulum.php" class="text-decoration-none">
          <div class="card border-0 shadow-sm h-100 text-center hover-lift">
            <div class="card-body p-4">
              <div class="icon-box mb-4">
                <div class="icon-circle bg-success-subtle">
                  <i class="fa fa-book fa-2x text-success"></i>
                </div>
              </div>
              <h5 class="card-title mb-3">Kurikulum</h5>
              <p class="card-text text-muted small mb-0">Pelajari kurikulum dan program pembelajaran di sekolah kami</p>
            </div>
          </div>
        </a>
      </div>
      <div class="col-lg-3 col-md-6">
        <a href="<?php echo base_url(); ?>/public/teachers.php" class="text-decoration-none">
          <div class="card border-0 shadow-sm h-100 text-center hover-lift">
            <div class="card-body p-4">
              <div class="icon-box mb-4">
                <div class="icon-circle bg-warning-subtle">
                  <i class="fa fa-chalkboard-teacher fa-2x text-warning"></i>
                </div>
              </div>
              <h5 class="card-title mb-3">Tenaga Pengajar</h5>
              <p class="card-text text-muted small mb-0">Kenali tenaga pengajar profesional dan berpengalaman kami</p>
            </div>
          </div>
        </a>
      </div>
      <div class="col-lg-3 col-md-6">
        <a href="<?php echo base_url(); ?>/public/kontak.php" class="text-decoration-none">
          <div class="card border-0 shadow-sm h-100 text-center hover-lift">
            <div class="card-body p-4">
              <div class="icon-box mb-4">
                <div class="icon-circle bg-info-subtle">
                  <i class="fa fa-phone fa-2x text-info"></i>
                </div>
              </div>
              <h5 class="card-title mb-3">Hubungi Kami</h5>
              <p class="card-text text-muted small mb-0">Hubungi kami untuk informasi lebih lanjut dan pertanyaan</p>
            </div>
          </div>
        </a>
      </div>
    </div>
  </div>
</section>

<script>
// Initialize carousel
(function(){
  var el = document.getElementById('heroCarousel');
  if (!el) return;
  try { 
    new bootstrap.Carousel(el, { 
      interval: 4500, 
      ride: 'carousel' 
    }); 
  } catch(e){}
})();
</script>

<?php require __DIR__ . '/_footer.php'; ?>
