<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
$siteName = get_setting('site_name', 'Sekolah Kita');
$db = get_db(); // FIX: pastikan $db terdefinisi
// Ambil data kontak
$stmt = $db->query("SELECT * FROM contacts ORDER BY id DESC LIMIT 1");
$kontak = $stmt->fetch(PDO::FETCH_ASSOC);
include '_header.php';
?>
<div class="container py-5">
  <h1 class="mb-4">Kontak Sekolah</h1>
  <?php if ($kontak): ?>
    <div class="row g-4">
      <div class="col-md-6">
        <div class="card p-4 mb-3 shadow-sm">
          <h5 class="mb-2">Alamat</h5>
          <div><?php echo nl2br(htmlspecialchars($kontak['alamat'], ENT_QUOTES, 'UTF-8')); ?></div>
          <hr>
          <div><strong>Telepon:</strong> <?php echo htmlspecialchars($kontak['telepon'], ENT_QUOTES, 'UTF-8'); ?></div>
          <div><strong>Email:</strong> <a href="mailto:<?php echo htmlspecialchars($kontak['email'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($kontak['email'], ENT_QUOTES, 'UTF-8'); ?></a></div>
        </div>
      </div>
      <div class="col-md-6">
        <?php if (!empty($kontak['maps'])): ?>
          <div class="ratio ratio-4x3 mb-3">
            <?php echo $kontak['maps']; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  <?php else: ?>
    <div class="alert alert-warning">Data kontak sekolah belum tersedia.</div>
  <?php endif; ?>
</div>
<?php include '_footer.php'; ?>
