<?php
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/db.php';
$db = get_db();
$teachers = $db->query('SELECT * FROM teachers ORDER BY name ASC')->fetchAll(PDO::FETCH_ASSOC);
require __DIR__ . '/_header.php';
?>
<section class="py-5">
  <div class="container">
    <h2 class="fw-bold mb-4">Daftar Guru</h2>
    <div class="row">
      <?php foreach ($teachers as $g): ?>
        <div class="col-md-4 mb-4">
          <div class="card h-100 shadow-sm">
            <?php if (!empty($g['photo'])): ?>
              <img src="<?php echo base_url(); ?>/data/uploads/teachers/<?php echo e($g['photo']); ?>" class="card-img-top" style="object-fit:cover;height:220px;">
            <?php endif; ?>
            <div class="card-body">
              <h5 class="card-title mb-1"><?php echo e($g['name']); ?></h5>
              <div class="mb-2 text-muted small"><?php echo e($g['subject']); ?></div>
              <?php if (!empty($g['contact'])): ?><div class="small">Kontak: <?php echo e($g['contact']); ?></div><?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
      <?php if (empty($teachers)): ?>
        <div class="col-12"><div class="alert alert-info">Belum ada data guru.</div></div>
      <?php endif; ?>
    </div>
  </div>
</section>
<?php require __DIR__ . '/_footer.php'; ?>
